/*******************************************************************
 *
 * Hitchhiker's Guide to the IBM PE 
 * Chapter 3 - Don't Panic
 *
 * To compile:
 * mpcc -g -o bad_life bad_life.c
 *
 *******************************************************************/

#include <stdio.h>
#include <mpi.h>

void main(int argc, char *argv[])
{ 
	int		taskid;
	MPI_Status 	stat;
 
	/* Find out number of tasks/nodes. */
	MPI_Init( &argc, &argv);
	MPI_Comm_rank( MPI_COMM_WORLD, &taskid);

	if ( (taskid % 2) == 0)
	{
		char	*send_message = NULL;

		send_message = (char *) malloc(10);
		strcpy(send_message, "Forty Two");
		MPI_Send(send_message, 10, MPI_CHAR, taskid+1, 0, 
			MPI_COMM_WORLD);
		free(send_message);
	} else 
	{
		char	*recv_message = NULL;                         

		MPI_Recv(recv_message, 10, MPI_CHAR, taskid-1, 0, 
			MPI_COMM_WORLD, &stat);
		printf("The answer is  %s\n", recv_message);
		free(recv_message);
	}
	printf("Task %d complete.\n",taskid);
	MPI_Finalize();
	exit(); 
}
